<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}


/**
* description
*
* @library	
* @author	
* @since	
*/
class CDate {

	function ToStr($format  , $stamp = null ) {

		if ($format == "friendly") {
			return CDate::Friendly($stamp);
		}
		

		if ($stamp === null) {
			$stamp = time();
		}



		if (strstr($format , "%")) {
			return strftime($format , $stamp);
		} else {				
			return date($format , $stamp);
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ToLangMonth($month) {

		$months = array(
			"1"		=> "{LANG:MONTH_JANUARY}",
			"2"		=> "{LANG:MONTH_FEBRUARY}",
			"3"		=> "{LANG:MONTH_MARCH}",
			"4"		=> "{LANG:MONTH_APRIL}",
			"5"		=> "{LANG:MONTH_MAY}",
			"6"		=> "{LANG:MONTH_JUNE}",
			"7"		=> "{LANG:MONTH_JULY}",
			"8"		=> "{LANG:MONTH_AUGUST}",
			"9"		=> "{LANG:MONTH_SEPTEMBER}",
			"10"	=> "{LANG:MONTH_OCTOBER}",
			"11"	=> "{LANG:MONTH_NOVEMBER}",
			"12"	=> "{LANG:MONTH_DECEMBER}",
		);

		return $months[$month];
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Friendly($stamp , $format = "") {

		if (!$stamp) {
			return "n/a";
		}
		

		return CDate::_friendly($stamp);

		return date($format , $stamp);
	}

	function _friendly($ptime) {
		$etime = time() - $ptime;

		if ($etime > 1) {
			$pref = ' ago';
		} elseif ( $etime > -1 ) {
			return "0 seconds";
		} else {
			$etime = abs($etime);
			$pref = " left";
		} 

		$a = array( 365 * 24 * 60 * 60  =>  'year',
					 30 * 24 * 60 * 60  =>  'month',
						  24 * 60 * 60  =>  'day',
							   60 * 60  =>  'hour',
									60  =>  'minute',
									 1  =>  'second'
					);

		$a_plural = array( 
			'year'   => 'years',
			'month'  => 'months',
			'day'    => 'days',
			'hour'   => 'hours',
			'minute' => 'minutes',
			'second' => 'seconds'
		);

		foreach ($a as $secs => $str) {
			$d = $etime / $secs;
			if ($d >= 1) {
				$r = round($d);
				return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . $pref;
			}
		}
	}
	
	
}



?>
